IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Produc_Cont_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Produc_Cont_Generar
END
GO


CREATE PROCEDURE [dbo].[CPJ_Produc_Cont_Generar]		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parßmetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Usuario			INT
DECLARE @pId_Contrato			INT
DECLARE @pId_Trans				INT
DECLARE @pTipo					CHAR(3)
DECLARE @pValor					VARCHAR(8000)
DECLARE @pObservacion	VARCHAR(200)									

SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pId_Trans				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)
SET @pTipo					= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Tipo')), '')
SET @pValor					= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@pJson,'Valor')), '')
SET @pObservacion			= ISNULL(CONVERT(VARCHAR(200), dbo.CF_JSON_VALUE(@pJson,'Observacion')), '')																								


--'' SOLO PRODUCTO   'PSH' - Producto sala horario 'PH'- Producto Horario
/*FIN Variables recibidas por parßmetro a traves del JSON*/

/*Variables Locales*/
DECLARE @Id_Producto VARCHAR(14),
		@Fecha_QA DATETIME,
		@Fecha_Venc DATETIME,
		@Id_Cliente INT,
		@Existe_Cotrato INT,
		@Id_Tipo_Con_Web_Auto INT,
		@Descripcion_CT VARCHAR(200),
		@Id_Tipo_Cbte_Ri CHAR(4),
		@Id_Tipo_Cbte CHAR(4),
		@Id_Iva CHAR(3),
		@Id_Lista_Precio SMALLINT
						   

/*FIN Variables Locales*/

/*Variable de Retorno del Stored*/
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
DECLARE @Result_Stored_Invocado				INT
/*FIN Variable de Retorono del Stored*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Produc_Cont_Generar'
		PRINT 'Parßmetros: '+ @pJson  
	END
	
	/*===================================================================*/	
	
	IF @pId_Trans <> 0
	BEGIN
	--Recorro todos los productos		
	DECLARE cur_Produc_Cont_Generar CURSOR FOR 	
			SELECT ISNULL(I.Id_Cliente,C.Id_Cliente),I.Id_Producto,I.Fecha_QA,I.Fecha_Venc,P.Id_Tipo_Con_Web_Auto,CT.Descripcion,CT.Id_Tipo_Cbte_Ri,CT.Id_Tipo_Cbte,E.Id_Iva,PF.Id_Lista_Precio_Web
		FROM Cbtes_Items I, Cbtes C, Cbtes_Tipos T , Productos P ,Contratos_Tipos CT, Clientes E, Prod_Familias PF
		WHERE I.Id_trans = C.Id_Trans 
		AND C.Id_Trans = @pId_Trans 
		AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
		AND P.Id_Producto = I.Id_Producto
		AND P.Id_Familia=PF.Id_Familia						
		AND T.Compromete_Factura = 1
		AND C.Id_Estado_Cbte NOT IN (0,3)
		AND ISNULL(P.Id_Tipo_Con_Web_Auto,0) <> 0
		AND CT.Id_Tipo_Con = Id_Tipo_Con_Web_Auto
		AND E.Id_Cliente = ISNULL(I.Id_Cliente,C.Id_Cliente)

	OPEN cur_Produc_Cont_Generar
	FETCH NEXT FROM cur_Produc_Cont_Generar INTO @Id_Cliente,@Id_Producto,@Fecha_QA,@Fecha_Venc,@Id_Tipo_Con_Web_Auto,@Descripcion_CT,@Id_Tipo_Cbte_Ri,@Id_Tipo_Cbte,@Id_Iva,@Id_Lista_Precio
	WHILE @@FETCH_STATUS = 0
	BEGIN
	    SET @Existe_Cotrato = 0
		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@Id_Producto: ' + CONVERT(VARCHAR(14), @Id_Producto) + ' @Id_Cliente: ' + CONVERT(VARCHAR(14), @Id_Cliente) +
			      '@Fecha_QA: ' + CONVERT(VARCHAR(14), @Fecha_QA,112) + '@Fecha_Venc: ' + CONVERT(VARCHAR(14), @Fecha_Venc,112) 
		END

		

		-----Verifico si existe el contrato --------------------------------------------------------------
		SET @Fecha_QA = ISNULL(@Fecha_QA,GETDATE())		
		SET @Fecha_Venc = ISNULL(@Fecha_Venc,GETDATE())
		
		IF @Fecha_Venc IS NULL
			SELECT TOP 1 @Existe_Cotrato = C.Id_Contrato FROM Contratos C 
				WHERE C.Id_Cliente = @Id_Cliente
					AND C.Activo = 1
					AND C.Id_Tipo_Con=30
					AND C.Fecha_Desde <= @Fecha_QA
					AND C.Fecha_Hasta IS NULL
        ELSE 
			SELECT TOP 1 @Existe_Cotrato = C.Id_Contrato FROM Contratos C 
				WHERE C.Id_Cliente = @Id_Cliente
					AND C.Activo = 1
					AND C.Id_Tipo_Con=30
					AND C.Fecha_Desde <= @Fecha_QA
					AND C.Fecha_Hasta >= @Fecha_Venc
        ---------------------------------------------------------------------------------------------------------

		IF ISNULL(@Existe_Cotrato,0) = 0	 						
		BEGIN
		   -------verifico la condición del iva para ver que tipo de cbte tiene que tomar --------------------------
		   IF dbo.CF_xParam('Iva_RI') = @Id_Tipo_Cbte_RI
			  SET @Id_Tipo_Cbte = @Id_Tipo_Cbte_RI
		   ---------------------------------------------------------------------------------------------------------


		   SELECT @Existe_Cotrato = MAX(C.Id_Contrato) FROM Contratos C
		   SET @Existe_Cotrato = ISNULL(@Existe_Cotrato,0) + 1
		   
		   INSERT INTO Contratos 
			   (Id_Contrato,		Id_Cliente,	Id_Tipo_Con,			Fecha_Alta,	Fecha_Desde, Fecha_Hasta,	Activo,	Id_Tipo_Cbte,	Descripcion,
			   Porc_Bonif,	Id_Lista_Precio,Id_Sucursal,Imp_Bonif,	Id_Grupo_Cont,	Id_SubGrupo_Cont, Observacion)
			   VALUES
			   (@Existe_Cotrato,	@Id_Cliente,@Id_Tipo_Con_Web_Auto,	GETDATE(),	@Fecha_QA,	@Fecha_Venc,	1,		@Id_Tipo_Cbte,LTRIM(RTRIM(@Descripcion_CT)) + ' (AUTO. WEB)',		
			   0,			@Id_Lista_Precio,				0,			0,			'',				'', @pObservacion)

			   UPDATE CBTES SET Id_Contrato=@Existe_Cotrato WHERE Id_Trans=@pId_Trans

		 IF(@pTipo='PSH')
		 BEGIN

			EXEC @Result_Stored_Invocado = dbo.CP_Contratos_Prod_PSH_Agregar @Existe_Cotrato, @Id_Producto, @pValor
			IF ISNULL(@Result_Stored_Invocado,0) <> 0 
			BEGIN
				/*El CP_Contratos_Prod_PSH_Agregar deberia devolver el SELECT con el error*/
				RETURN 
			END
		 END
		 ELSE
		 BEGIN

			INSERT INTO Contratos_Prod 
			   (Id_Contrato,		Item,	Id_Producto,	Precio,	Precio_Formula,	Cant_Cuotas,	
			   Observa_Fact,	Flag_Facturable,	Cantidad,	Cant_Includ, Flag_No_Bonificable,	Id_Prod_Familia_Sala)
			   VALUES
			   (@Existe_Cotrato,	1,		@Id_Producto,	0,		'',				0,				
			   '',					1,				1,			0,			0,						0)
			END
		END

		FETCH NEXT FROM cur_Produc_Cont_Generar INTO @Id_Cliente,@Id_Producto,@Fecha_QA,@Fecha_Venc,@Id_Tipo_Con_Web_Auto,@Descripcion_CT,@Id_Tipo_Cbte_Ri,@Id_Tipo_Cbte,@Id_Iva,@Id_Lista_Precio
	END
	CLOSE cur_Produc_Cont_Generar
	DEALLOCATE cur_Produc_Cont_Generar
	--FIN Recorro todos los productos



	END --IF @pId_Trans <> 0

	/*===================================================================*/	

	IF @pFlagUsarTrans <> 0 COMMIT

	SELECT	 0							AS ErrorNumber 
			,0							AS ErrorSeverity  
			,0							AS ErrorState 
			,0							AS ErrorProcedure  
			,0							AS ErrorLine		
			,@Existe_Cotrato							AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Produc_Cont_Generar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  
	BEGIN
		ROLLBACK
	END

END CATCH

RETURN 0 

--Ejemplo de uso
--EXEC CPJ_Produc_Cont_Generar '{"FlagUsarTrans":"0", "ModoDebug":"1", "Id_Trans":"2"}'
